﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;


/* synchronizing threads for the first time.
   Passing data from a secondary thread, back to the primary UI thread in a synchronized manner
   using the WindowsFormsSynchronizationContext class and its Post() and Send() methods */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            synContext = WindowsFormsSynchronizationContext.Current;
        }

        Thread t = null;
        SynchronizationContext synContext;
 
        void ThreadProc()
        {
            /* calling directly from one thread to another causes an InvalidOperationException */
            //SynchronizedMethod("Thread started at: " + DateTime.Now.ToString());  // InvalidOperationException here

            /* syncronized calls from on thread to another */
            synContext.Send(SynchronizedMethod, "Thread started at: " + DateTime.Now.ToString());
            Thread.Sleep(3000);
            synContext.Send(SynchronizedMethod, "Thread terminated at: " + DateTime.Now.ToString());
        }

        void SynchronizedMethod(object state)
        {
            textBox1.Text += state.ToString() + Environment.NewLine;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if ((t == null) || (!t.IsAlive))    // IsAlive is true when the thread has been started and has not terminated         
            {
                t = new Thread(ThreadProc);     // create a thread
                t.Start();                      // and start it
            }
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = (t != null) && (t.IsAlive);

            if (e.Cancel)
                MessageBox.Show("Please wait! A thread is still executed...");
        }
    }
}
